<?php
declare(strict_types=1);


class ProductValidator
{

    private const VALID_ACTIONS = [
        'insert', 'update',
    ];

    private ?string $actionName = null;


    public function isProductAVoucher(string $productModel): bool
    {
        $result = false;

        if ((empty($productModel)) || (is_null($this->actionName))){
            $result = false;
        }

        if (preg_match('/^GIFT_/', $productModel)) {
            $result = true;
        }

        return $result;
    }

    public function setAction(string $actionName): ?self
    {
        if (!in_array($actionName, self::VALID_ACTIONS)) {
            return null;
        }
        $this->actionName = $actionName;

        return $this;
    }

    public function removeBrackets(string $productModel): ?string
    {
        if ((empty($productModel)) || (is_null($this->actionName))) {
            return null;
        }

        $pattern = array('[', ']');
        $validName = str_replace($pattern, '', $productModel);

        return $validName;
    }
}